<?php

namespace Modules\Amazon\Database\Factories;

use App\Models\SalesOrderFulfillment;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Amazon\Entities\AmazonFulfillmentOrder;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

class AmazonFulfillmentOrderFactory extends Factory
{
    protected $model = AmazonFulfillmentOrder::class;

    public function definition(): array
    {
        return [
            'integration_instance_id' => AmazonIntegrationInstance::factory(),
            'sales_order_fulfillment_id' => SalesOrderFulfillment::factory(),
            'json_object' => [
                'sellerFulfillmentOrderId' => $this->faker->word(),
                'marketplaceId' => $this->faker->word(),
                'displayableOrderId' => $this->faker->word(),
                'displayableOrderDate' => $this->faker->word(),
                'displayableOrderComment' => $this->faker->word(),
                'shippingSpeedCategory' => $this->faker->word(),
                'deliveryWindow' => $this->faker->word(),
                'destinationAddress' => $this->faker->words(),
                'fulfillmentAction' => $this->faker->word(),
                'fulfillmentPolicy' => $this->faker->word(),
                'codSettings' => $this->faker->words(),
                'notificationEmails' => $this->faker->words(),
                'featureConstraints' => $this->faker->words(),
                'receivedDate' => $this->faker->word(),
                'fulfillmentOrderStatus' => $this->faker->word(),
                'statusUpdatedDate' => $this->faker->word(),
            ],
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
