<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFinancialShipmentEvent;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Modules\Amazon\Entities\AmazonFinancialShipmentEvent>
 */
class AmazonFinancialShipmentEventFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFinancialShipmentEvent::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'json_object' => [

            ],
        ];
    }
}
