<?php

namespace Modules\Amazon\Database\Factories;

use App\Models\NominalCode;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFinancialEventTypeNominalCodeMapping;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Modules\Amazon\Entities\AmazonFinancialEventTypeNominalCodeMapping>
 */
class AmazonFinancialEventTypeNominalCodeMappingFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFinancialEventTypeNominalCodeMapping::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        $nominalCode = NominalCode::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'name' => $this->faker->unique()->word(),
            'nominal_code_id' => $nominalCode->id,
        ];
    }
}
