<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFeedSubmission;
use Modules\Amazon\Enums\Entities\AmazonFeedTypeEnum;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Modules\Amazon\Entities\AmazonFeedSubmission>
 */
class AmazonFeedSubmissionFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFeedSubmission::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [

            'feedId' => $this->faker->numberBetween(100, 999),
            'feedType' => AmazonFeedTypeEnum::ORDER_FULFILLMENT(),
            'inputFeedDocumentId' => $this->faker->numberBetween(100, 999),
            'feedOptions' => [],
            'createdTime' => now()->toIso8601ZuluString(),
            'processingStatus' => 'DONE',
            'processingStartTime' => now()->toIso8601ZuluString(),
            'processingEndTime' => now()->toIso8601ZuluString(),
            'resultFeedDocumentId' => $this->faker->numberBetween(100, 999),
        ];
    }
}
