<?php

namespace Modules\Amazon\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaReportRemovalShipment;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;

class AmazonFbaReportRemovalShipmentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaReportRemovalShipment::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        $shipmentDate = Carbon::parse($this->faker->date());

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'amazon_report_id' => AmazonReport::factory(),
            'event_datetime' => $shipmentDate->copy(),
            'json_object' => [
                'shipment_date' => $shipmentDate->copy()->toIso8601String(),
                'order_id' => $this->faker->word(),
                'sku' => $this->faker->word(),
                'fnsku' => $this->faker->word(),
                'disposition' => $this->faker->word(),
                'shipped_quantity' => $this->faker->randomNumber(),
                'carrier' => $this->faker->word(),
                'tracking_number' => $this->faker->word(),
            ],
        ];
    }
}
