<?php

namespace Modules\Amazon\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaReportRemovalOrder;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;
use Modules\Amazon\Enums\Entities\FbaRemovalOrderStatusEnum;
use Modules\Amazon\Enums\Entities\FbaRemovalOrderTypeEnum;

class AmazonFbaReportRemovalOrderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaReportRemovalOrder::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'amazon_report_id' => AmazonReport::factory(),
            'json_object' => [
                'request_date' => Carbon::parse($this->faker->date())->toIso8601String(),
                'order_id' => $this->faker->word(),
                'order_type' => $this->faker->randomElement(FbaRemovalOrderTypeEnum::values()),
                'order_status' => $this->faker->randomElement(FbaRemovalOrderStatusEnum::values()),
                'sku' => $this->faker->word(),
                'fnsku' => $this->faker->word(),
                'disposition' => $this->faker->word(),
                'requested_quantity' => $this->faker->randomNumber(),
                'cancelled_quantity' => $this->faker->randomNumber(),
                'disposed_quantity' => $this->faker->randomNumber(),
                'shipped_quantity' => $this->faker->randomNumber(),
                'in_process_quantity' => $this->faker->randomNumber(),
                'removal_fee' => $this->faker->randomFloat(2),
                'currency' => $this->faker->currencyCode(),
            ],
            'checksum' => $this->faker->word(),
        ];
    }
}
