<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedgerSummary;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;

class AmazonFbaReportInventoryLedgerSummaryFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaReportInventoryLedgerSummary::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        $reportDate = $amazonIntegrationInstance->fbaInventoryTrackingStartDate();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'amazon_report_id' => AmazonReport::factory(),
            'json_object' => [
                'date' => $reportDate->copy()->format('m/d/Y'),
                'fnsku' => $this->faker->word(),
                'asin' => $this->faker->word(),
                'msku' => $this->faker->word(),
                'title' => $this->faker->word(),
                'disposition' => $this->faker->word(),
                'starting_warehouse_balance' => $this->faker->randomNumber(),
                'in_transit_between_warehouses' => $this->faker->randomNumber(),
                'receipts' => $this->faker->randomNumber(),
                'customer_shipments' => $this->faker->randomNumber(),
                'customer_returns' => $this->faker->randomNumber(),
                'vendor_returns' => $this->faker->randomNumber(),
                'warehouse_transfer_in_out' => $this->faker->randomNumber(),
                'found' => $this->faker->randomNumber(),
                'lost' => $this->faker->randomNumber(),
                'damaged' => $this->faker->randomNumber(),
                'disposed' => $this->faker->randomNumber(),
                'other_events' => $this->faker->randomNumber(),
                'ending_warehouse_balance' => $this->faker->randomNumber(),
                'location' => $amazonIntegrationInstance->integration->country,
            ],
        ];
    }
}
