<?php

namespace Modules\Amazon\Database\Factories;

use App\Abstractions\JsonObjectFactory;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;
use Modules\Amazon\Enums\Entities\FbaInventoryLedgerReportEventTypeEnum;

class AmazonFbaReportInventoryLedgerFactory extends JsonObjectFactory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaReportInventoryLedger::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        $reportDate = Carbon::parse($this->faker->dateTimeBetween('-1 month', 'now'));

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'amazon_report_id' => AmazonReport::factory(),
            'event_datetime' => $reportDate->copy(),
            'json_object' => [
                'date' => $reportDate->copy()->toIso8601String(),
                'fnsku' => $this->faker->word(),
                'asin' => $this->faker->word(),
                'msku' => $this->faker->word(),
                'title' => $this->faker->word(),
                'event_type' => $this->faker->randomElement(FbaInventoryLedgerReportEventTypeEnum::Kept),
                'reference_id' => $this->faker->word(),
                'quantity' => $this->faker->randomNumber(1),
                'fulfillment_center' => $this->faker->word(),
                'disposition' => $this->faker->word(),
                'reason' => $this->faker->word(),
                'country' => 'US',
            ],
        ];
    }
}
