<?php

namespace Modules\Amazon\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaReportCustomerReturn;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;

class AmazonFbaReportCustomerReturnFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaReportCustomerReturn::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'amazon_report_id' => AmazonReport::factory(),
            'event_datetime' => $this->faker->date(),
            'json_object' => [
                'return_date' => Carbon::parse($this->faker->date())->toIso8601String(),
                'order_id' => $this->faker->word(),
                'sku' => $this->faker->word(),
                'asin' => $this->faker->word(),
                'fnsku' => $this->faker->word(),
                'product_name' => $this->faker->word(),
                'quantity' => $this->faker->randomNumber(),
                'fulfillment_center_id' => $this->faker->word(),
                'detailed_disposition' => $this->faker->word(),
                'reason' => $this->faker->word(),
                'status' => $this->faker->word(),
                'license_plate_number' => $this->faker->word(),
                'customer_comments' => $this->faker->sentence(),

            ],
        ];
    }
}
