<?php

namespace Modules\Amazon\Database\Factories;

use App\Models\FifoLayer;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaInitialInventory;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;

class AmazonFbaInitialInventoryFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaInitialInventory::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        $reportDate = $amazonIntegrationInstance->fbaInventoryTrackingStartDate();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'amazon_report_id' => AmazonReport::factory(),
            'fifo_layer_id' => FifoLayer::factory(),
            'sku_product_initialized_at' => $reportDate,
            'json_object' => [
                'date' => $reportDate->copy()->format('m/d/Y'),
                'fnsku' => $this->faker->word(),
                'asin' => $this->faker->word(),
                'msku' => $this->faker->word(),
                'title' => $this->faker->word(),
                'disposition' => $this->faker->word(),
                'starting_warehouse_balance' => 0,
                'in_transit_between_warehouses' => 0,
                'receipts' => 0,
                'customer_shipments' => 0,
                'customer_returns' => 0,
                'vendor_returns' => 0,
                'warehouse_transfer_in_out' => 0,
                'found' => 0,
                'lost' => 0,
                'damaged' => 0,
                'disposed' => 0,
                'other_events' => 0,
                'ending_warehouse_balance' => 0,
                'unknown_events' => 0,
                'location' => 'US',
            ],
        ];
    }
}
