<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Amazon\Entities\AmazonFbaInboundShipFromMapping;

class AmazonFbaInboundShipFromMappingFactory extends Factory
{
    protected $model = AmazonFbaInboundShipFromMapping::class;

    public function definition(): array
    {
        return [
            'integration_instance_id' => $this->faker->randomNumber(),
            'name' => $this->faker->name(),
            'link_id' => $this->faker->randomNumber(),
            'link_type' => $this->faker->word(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
