<?php

namespace Modules\Amazon\Data;

use App\Abstractions\Integrations\Data\StoreSalesChannelIntegrationDataInterface;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class StoreAmazonIntegrationData extends Data implements StoreSalesChannelIntegrationDataInterface
{
    public function __construct(
        public string $name,
        #[Exists('integrations', 'id')]
        public int $integration_id,
        public AmazonConnectionSettingsData|Optional $connection_settings,
        public AmazonIntegrationSettingsData $integration_settings,
        public bool $is_automatic_sync_enabled = false,
        public ?string $country = null,
    )
    {
    }
}