<?php

namespace Modules\Amazon\Data;

use Modules\Amazon\Enums\Entities\FbaRemovalOrderTypeEnum;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;

class RemovalOrderGroupData extends Data
{
    public function __construct(
        public string $order_id,
        public string $request_date,
        public FbaRemovalOrderTypeEnum $order_type,
        public string $order_status,
        public string $last_updated_date,
        #[DataCollectionOf(RemovalOrderLineData::class)]
        public DataCollection $removalOrderLines,
    )
    {
    }
}
