<?php

namespace Modules\Amazon\Data;

use Carbon\Carbon;
use Modules\Amazon\Entities\AmazonFnskuProduct;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class FbaInventoryValuationFnskuProductData extends Data
{
    public function __construct(
        public AmazonFnskuProduct $fnskuProduct,
        public int $quantity,
        public float|Optional $averageCost,
        public float $valuation,
        public int $summaryQuantity = 0,
        public int $discrepancy = 0,
        public int $quantityFromInitialInventory = 0,
        public int $quantityFromSummary = 0,
        public int $quantityFromLedgers = 0,
    )
    {
    }
}
