<?php

namespace Modules\Amazon\Data;

use Carbon\Carbon;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class AmazonReportData extends Data
{
    public function __construct(
        public int|Optional $id,
        public string|null $reportId,
        public string $reportType,
        public Optional|string|null $dataStartTime,
        public Optional|string|null $dataEndTime,
        public Optional|array|null $options,
        public Optional|string|null $reportScheduledId,
        public Optional|string|null $createdTime,
        public Optional|string|null $processingStatus,
        public Optional|string|null $processingStartTime,
        public Optional|string|null $processingEndTime,
        public Optional|array|string|null $marketplaceIds,
        public Optional|string|null $reportDocumentId,
        public Optional|int $integration_instance_id,
        public Optional|int $recordsCount,
    ) {
        foreach ($this->getDateFields() as $dateField) {
            if (!$this->{$dateField} instanceof Optional) {
                $this->{$dateField} = Carbon::parse($this->{$dateField})->toDateTimeString();
            }
        }
    }

    private function getDateFields(): array
    {
        return [
            'dataStartTime',
            'dataEndTime',
            'createdTime',
            'processingStartTime',
            'processingEndTime',
        ];
    }
}
