<?php

namespace Modules\Amazon\Data;

use App\Abstractions\Integrations\Data\SalesChannelIntegrationSettingsData;
use App\Data\SalesChannelInventoryLocationsData;
use App\Data\SalesChannelInventorySettingsData;
use App\Data\SalesChannelPricingSettingsData;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class AmazonIntegrationSettingsData extends SalesChannelIntegrationSettingsData
{
    public function __construct(
        public string $start_date,
        public int $store_id,
        public bool $auto_link_products,
        public bool $auto_create_products,
        public ?int $sales_nominal_code_id,
        public ?int $cogs_nominal_code_id,
        public SalesChannelPricingSettingsData|Optional $pricing,
        public SalesChannelInventorySettingsData|Optional $inventory,
        #[DataCollectionOf(SalesChannelInventoryLocationsData::class)]
        public DataCollection|Optional $inventoryLocations,
        public bool $is_fba_enabled,
        public string $fba_inventory_tracking_start_date,
        public bool $batch_sales_order_invoices,
        public array|Optional $marketplaceParticipations,
        public string|Optional $catalogMarketplaceId,
        public bool $emailCustomers = false,
        public ?float $proforma_marketplace_cost_percentage = 15,
        public ?float $proforma_payment_cost_percentage = null,
        public bool $automatically_create_warehouse_transfers_from_inbounds = false,
        public bool $automatically_create_purchase_orders_from_inbounds = false,
        public bool $automatically_create_warehouse_transfers_from_removal_orders = false,
        public ?int $removal_order_warehouse_id = null,
        public bool $sync_sales_order_invoices_to_accounting = true,
    ) {
        // Always false for Amazon
        $this->emailCustomers = false;
        parent::__construct(
            $start_date,
            $store_id,
            $auto_link_products,
            $auto_create_products,
            $sales_nominal_code_id,
            $cogs_nominal_code_id,
            $pricing,
            $inventory,
            $emailCustomers,
            $proforma_marketplace_cost_percentage,
            $proforma_payment_cost_percentage,
            $sync_sales_order_invoices_to_accounting
        );
    }
}