<?php

namespace Modules\Amazon\Data;

use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class AmazonFulfillmentOrderData extends Data
{
    public string $sellerFulfillmentOrderId;

    public string $displayableOrderId;

    public string $displayableOrderDate;

    public string|null $displayableOrderComment;

    public string $shippingSpeedCategory;

    public AmazonAddressData $destinationAddress;

    #[DataCollectionOf(AmazonFulfillmentOrderItemData::class)]
    public DataCollection|Optional $items;

    public string $fulfillmentAction = 'Ship';

    public string $fulfillmentPolicy = 'FillOrKill';
}
