<?php

namespace Modules\Amazon\Data;

use Modules\Amazon\Enums\Entities\AmazonFeedTypeEnum;
use Spatie\LaravelData\Data;

class AmazonFeedData extends Data
{
    public function __construct(
        public string $feedId,
        public ?string $processingStatus,
        public ?array $marketplaceIds,
        public ?AmazonFeedTypeEnum $feedType,
        public ?string $createdTime,
        public ?string $processingStartTime,
        public ?string $processingEndTime,
        public ?string $resultFeedDocumentId,
        public ?array $metadata,
    ) {
    }
}
