<?php

namespace Modules\Amazon\Data;

use App\Models\Warehouse;
use Modules\Amazon\Entities\AmazonFbaInboundShipFromMapping;
use Modules\Amazon\Entities\AmazonFbaInboundShipment;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class AmazonFbaInboundShipmentWithMappingData extends Data
{
    public function __construct(
        public AmazonFbaInboundShipment $shipment,
        public AmazonFbaInboundShipFromMapping|Optional $mapping,
        public Warehouse|Optional $warehouse,
    )
    {
    }
}
