<?php

namespace Modules\Amazon\Data;

use App\Abstractions\Integrations\Data\OauthAuthenticationAuthorizationResponseInterface;
use Spatie\LaravelData\Data;

class AmazonAuthorizationResponseData extends Data implements OauthAuthenticationAuthorizationResponseInterface
{
    public function __construct(
        public string $state,
        public string $spapi_oauth_code,
        public string $selling_partner_id,
    )
    {
    }

    public function getAuthCode(): string
    {
        return $this->spapi_oauth_code;
    }

    public function getAdditionalInfo(): array
    {
        return [
            'selling_partner_id' => $this->selling_partner_id,
        ];
    }
}
