<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\SeedAmazonReportSettlementDataTypeMappingsJob;

class SeedAmazonReportSettlementTypeDataMappingsCommand extends AbstractAmazonCommand
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'amazon:finances:seed-settlement-mappings {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Seed the settlement data type mappings for the Amazon integration instances.';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            dispatch(new SeedAmazonReportSettlementDataTypeMappingsJob($amazonIntegrationInstance));
        });
    }
}
