<?php

namespace Modules\Amazon\Console;

use Illuminate\Console\Command;
use Modules\Amazon\Repositories\AmazonOrderRepository;

class ResetAmazonPIIDataCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'amazon:orders:reset-pii-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reset BuyerInfo and ShippingAddress to null once order is fulfilled.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(private readonly AmazonOrderRepository $amazonOrderRepository)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->amazonOrderRepository->resetPiiDataForFulfilledOrders();
    }
}
