<?php

namespace Modules\Amazon\Console;

use Carbon\Carbon;
use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetOrdersAdt;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonOrder;
use Modules\Amazon\Jobs\RefreshAmazonOrdersJob;

class RefreshAmazonOrdersCommand extends AbstractAmazonCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:orders:refresh {integrationInstanceId?} {--lastUpdatedAfter=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon Orders';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $query = $this->integrationInstanceRepository
            ->all($this->argument('integrationInstanceId'));

        $parameters = new AmazonGetOrdersAdt(
            last_updated_after: $this->option('lastUpdatedAfter'),
        );

        $query
            ->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) use ($parameters) {
                if (is_null($parameters->last_updated_after)) {
                    $lastUpdateAfter = AmazonOrder::select('LastUpdateDate')->orderBy('LastUpdateDate', 'desc')->first();

                    $parameters->last_updated_after = $lastUpdateAfter ? Carbon::parse($lastUpdateAfter->LastUpdateDate) : now()->subMonth(); //TODO: Start date
                }

                RefreshAmazonOrdersJob::dispatch($amazonIntegrationInstance, $parameters);
            });
    }
}
