<?php

namespace Modules\Amazon\Console;

use Carbon\Carbon;
use DB;
use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetFinancialEventsAdt;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\RefreshAmazonFinancialEventsJob;

class RefreshAmazonFinancialEventsCommand extends AbstractAmazonCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:financial-events:refresh {integrationInstanceId?} {--postedAfter=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon Financial Events';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $query = $this->integrationInstanceRepository
            ->all($this->argument('integrationInstanceId'));

        $parameters = new AmazonGetFinancialEventsAdt(
            posted_after: $this->option('postedAfter'),
        );

        $query
            ->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) use ($parameters) {

                if (is_null($parameters->posted_after)) {
                    $postedDate = DB::table('amazon_financial_shipment_events')
                        ->select(DB::raw('MAX(PostedDate) as PostedDate'))
                        ->union(
                            DB::table('amazon_financial_refund_events')
                                ->select(DB::raw('MAX(PostedDate) as PostedDate'))
                        )
                        ->orderByDesc('PostedDate')
                        ->first();

                    $parameters->posted_after = $postedDate?->PostedDate ? Carbon::parse($postedDate->PostedDate) : now()->subMonth();
                }

                RefreshAmazonFinancialEventsJob::dispatch($amazonIntegrationInstance, $parameters);
            });
    }
}
