<?php

namespace Modules\Amazon\Console;

use App\Helpers;
use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\RefreshAmazonFinancialEventGroupsJob;

class RefreshAmazonFinancialEventGroupsCommand extends AbstractAmazonCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:finances:groups:refresh {integrationInstanceId?} {--startedAfter=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon Financial Event Groups';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            RefreshAmazonFinancialEventGroupsJob::dispatch($amazonIntegrationInstance, $this->option('startedAfter') ? Helpers::dateLocalToUtc($this->option('startedAfter')) : null);
        });
    }
}
