<?php

namespace Modules\Amazon\Console;

use App;
use Illuminate\Console\Command;
use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Jobs\RefreshAmazonFeedSubmissionJob;
use Modules\Amazon\Repositories\AmazonFeedRepository;

class RefreshAmazonFeedSubmissionCommand extends AbstractAmazonCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:feeds:refresh {integrationInstanceId?} {--feedId=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon Feed Details.';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if (App::environment() !== 'production') {
            return;
        }

        if ($this->option('feedId')) {
            RefreshAmazonFeedSubmissionJob::dispatch($this->option('feedId'));
        } else {
            $this->integrationInstances()->each(function ($integrationInstance) {
                foreach (app(AmazonFeedRepository::class)->getPendingFeedSubmissions($integrationInstance) as $amazonFeedSubmission) {
                    RefreshAmazonFeedSubmissionJob::dispatch($amazonFeedSubmission->feedId);
                }
            });
        }
    }
}
