<?php

namespace Modules\Amazon\Console;

use App\Helpers;
use Illuminate\Console\Command;
use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonFinancialEventGroup;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\SyncAmazonFinancialEventsJob;
use Modules\Amazon\Repositories\AmazonFinancialEventGroupRepository;

/**
 * @deprecated
 *
 * This command is deprecated since we are using RefreshAmazonSettlementReportsCommand for a simpler approach.
 * We are not 100% sure if we need to use the Finance API for anything the settlement report can't do, so we are leaving
 * this command here for now.
 */
class GetAmazonFinancialEventsCommand extends AbstractAmazonCommand
{
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(
        private readonly AmazonFinancialEventGroupRepository $amazonFinancialEventGroupRepository
    ) {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:finances:events:get {integrationInstanceId?} {--financialEventGroupId=} {--postedAfter=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon Financial Events';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            if ($this->option('financialEventGroupId')) {
                if (! $amazonFinancialEventGroups =
                    collect($this->amazonFinancialEventGroupRepository
                        ->getFromFinancialEventGroupId(
                            $amazonIntegrationInstance->id,
                            $this->option('financialEventGroupId')
                        ))) {
                    $this->error("Financial Event Group {$this->option('financialEventGroupId')} not found");

                    return 0;
                }
            } else {
                $amazonFinancialEventGroups = $this->amazonFinancialEventGroupRepository->getClosedWithoutEvents($amazonIntegrationInstance);
            }

            $amazonFinancialEventGroups->each(function (AmazonFinancialEventGroup $amazonFinancialEventGroup) use ($amazonIntegrationInstance) {
                dispatch(new SyncAmazonFinancialEventsJob(
                    $amazonIntegrationInstance,
                    $amazonFinancialEventGroup,
                    $this->option('postedAfter') ?
                        Helpers::dateLocalToUtc($this->option('postedAfter')) : null
                ));
            });
        });
    }
}
