<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\CreateAmazonRefreshFbaInboundShipmentItemsJobs;

class GetAmazonFbaInboundShipmentItemsCommand extends AbstractAmazonCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:inbound-shipments:get-items {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon FBA Inbound Shipment Items';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            CreateAmazonRefreshFbaInboundShipmentItemsJobs::dispatch($amazonIntegrationInstance);
        });
    }
}
