<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\CreateAmazonSearchCatalogItemsJobsJob;

class GetAmazonCatalogItemsCommand extends AbstractAmazonCommand
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'amazon:products:get-catalog {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon Catalog Items';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            dispatch(new CreateAmazonSearchCatalogItemsJobsJob($amazonIntegrationInstance))->onQueue('sales-channels');
        });
    }
}
