<?php

namespace Modules\Amazon\Console;

use Exception;
use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\CreateSkuProductsFromAmazonJob;

class CreateSkuProductsFromAmazonCommand extends AbstractAmazonCommand
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'amazon:products:create-sku-products {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create SKU products from Amazon';

    /**
     * Execute the console command.
     *
     * @throws Exception
     */
    public function handle(): void
    {
        $this->integrationInstances()->where('integration_settings.auto_create_products', true)->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            if ($amazonIntegrationInstance->integration_settings['auto_create_products']) {
                dispatch(new CreateSkuProductsFromAmazonJob($amazonIntegrationInstance));
            }
        });
    }
}
