<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\CreateAmazonFinancialEventGroupAccountingTransactionsJob;

class CreateAmazonFinancialEventGroupAccountingTransactionsCommand extends AbstractAmazonCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:finances:groups:create-accounting {integrationInstanceId?} {--ids=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon FBA Inbound Shipment Items';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $ids = $this->option('ids') ? explode(',', $this->option('ids')) : [];

        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) use ($ids) {
            CreateAmazonFinancialEventGroupAccountingTransactionsJob::dispatch($amazonIntegrationInstance, $ids);
        });
    }
}
