<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\CreateAmazonFeedJob;
use Modules\Amazon\Repositories\AmazonFeedRepository;
use Throwable;

class CreateAmazonFeedsCommand extends AbstractAmazonCommand
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'amazon:feeds:create {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create queued Amazon Feeds.';

    /**
     * Create a new command instance.
     */
    public function __construct(
        private readonly AmazonFeedRepository $feedRepository
    ) {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            foreach ($this->feedRepository->getFeedRequests($amazonIntegrationInstance) as $amazonReportRequest) {
                dispatch(new CreateAmazonFeedJob($amazonReportRequest->id));
            }
        });
    }
}
