<?php

namespace Modules\Amazon\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;

class AmazonGetInboundShipmentAdt implements ApiDataTransformerInterface
{
    public function __construct(
        public string $planId,
        public string $shipmentId,
    ) {
    }

    public function transform(): array
    {
        $params = [
            'planId' => $this->planId,
            'shipmentId' => $this->shipmentId,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
