<?php

namespace Modules\Amazon\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Carbon\Carbon;
use Modules\Amazon\ApiDataTransferObjects\Concerns\AmazonDatesTrait;
use Modules\Amazon\Enums\Entities\AmazonMarketplaceIdsEnum;
use Modules\Amazon\Enums\Entities\FbaInboundPlanStatusEnum;

class AmazonGetInboundPlansAdt implements ApiDataTransformerInterface
{
    public function __construct(
        public ?FbaInboundPlanStatusEnum $status = null,
        public ?string $paginationToken = null,
        public int $pageSize = 30,
    ) {
    }

    public function transform(): array
    {
        $params = [
            'pageSize' => $this->pageSize,
            'paginationToken' => $this->paginationToken,
            'status' => $this->status?->value,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
