<?php

namespace Modules\Amazon\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Carbon\Carbon;
use Modules\Amazon\ApiDataTransferObjects\Concerns\AmazonDatesTrait;

class AmazonGetFinancialEventsAdt implements ApiDataTransformerInterface
{
    use AmazonDatesTrait;

    const DATES_TO_SANITIZE = [
        'posted_after',
        'posted_before',
    ];

    public function __construct(
        public Carbon|string|null $posted_after = null,
        public Carbon|string|null $posted_before = null,
        public ?int $days = null,
        public ?string $nextToken = null,
    ) {
        $this->sanitizeDates();
        if (! is_null($days)) {
            $this->setStartAndEndDateFromDays($days);
        }
    }

    public function transform(): array
    {
        $params = [
            'PostedAfter' => $this->getZuluDate('posted_after'),
            'PostedBefore' => $this->getZuluDate('posted_before'),
            'NextToken' => $this->nextToken,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
