<?php

namespace Modules\Amazon\Actions;

use Modules\Amazon\Enums\Entities\AmazonFeedTypeEnum;
use Modules\Amazon\Repositories\AmazonFeedRepository;
use Throwable;

class RequestAmazonFeed
{
    protected AmazonFeedRepository $feedRepository;

    public function __construct(
        protected int $integration_instance_id,
        protected AmazonFeedTypeEnum $feed_type,
        protected ?array $options = [],
        protected ?array $metadata = []
    ) {
        $this->feedRepository = app(AmazonFeedRepository::class);
    }

    /**
     * @throws Throwable
     */
    public function handle(bool $createImmediately = true, bool $checkIfSimilarRequestExists = true): bool|array
    {
        if ($checkIfSimilarRequestExists && $this->feedRepository->requestExists($this->integration_instance_id, $this->feed_type)) {
            return false;
        }

        $feedRequest = $this->feedRepository->saveRequest(
            $this->integration_instance_id,
            $this->feed_type,
            $this->options,
            $this->metadata
        );

        $feedSubmission = $createImmediately ? (new CreateAmazonFeedSubmission($feedRequest))->handle() : null;

        return [
            'feedRequest' => $feedRequest,
            'feedSubmission' => $feedSubmission,
        ];
    }
}
