<?php

namespace Modules\Amazon\Actions\LedgerSummaryActions;

use App\Exceptions\InsufficientStockException;
use App\Services\InventoryManagement\InventoryEvent;
use Exception;
use Illuminate\Support\Collection;
use Modules\Amazon\Data\AmazonLedgerSummaryAdjustmentData;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedgerSummary;
use Modules\Amazon\Enums\Entities\AmazonLedgerSummaryAdjustmentTypeEnum;
use Throwable;

class AmazonLedgerSummaryUnknownEventsHandler
{
    /**
     * @throws InsufficientStockException
     * @throws Throwable
     */
    public function handle(AmazonFbaReportInventoryLedgerSummary $ledgerSummary, Collection $amazonLedgerSummaryAdjustmentDataCollection): void
    {
        if ($ledgerSummary->unknown_events == 0) {
            return;
        }

        /** @var InventoryEvent $adjustment */
        if (!$adjustment = $ledgerSummary->inventoryAdjustments->where('type', AmazonLedgerSummaryAdjustmentTypeEnum::UnknownEventsAdjustment)->first())
        {
            $amazonLedgerSummaryAdjustmentDataCollection->push(AmazonLedgerSummaryAdjustmentData::from([
                'amazon_fba_report_inventory_ledger_summary_id' => $ledgerSummary->id,
                'type' => AmazonLedgerSummaryAdjustmentTypeEnum::UnknownEventsAdjustment,
                'inventory_adjustment_id' => app(AmazonCreateInventoryAdjustmentFromLedgerSummary::class)->handle(
                    $ledgerSummary,
                    $ledgerSummary->unknown_events,
                    "FNSKU $ledgerSummary->fnsku " . friendlyName(AmazonLedgerSummaryAdjustmentTypeEnum::UnknownEventsAdjustment->value)
                )->id,
            ]));
        } elseif ($adjustment->getQuantity() != $ledgerSummary->unknown_events) {
            throw new Exception('Mismatched unknown events adjustment for FNSKU ' . $ledgerSummary->fnsku . ' summary ID ' . $ledgerSummary->id);
        }
    }
}