<?php

namespace Modules\Amazon\Actions\LedgerSummaryActions;

use App\Exceptions\InsufficientStockException;
use App\Models\InventoryAdjustment;
use App\Services\InventoryManagement\InventoryManager;
use Carbon\Carbon;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedgerSummary;
use Throwable;

class AmazonCreateInventoryAdjustmentFromLedgerSummary
{
    /**
     * @throws InsufficientStockException
     * @throws Throwable
     */
    public function handle(AmazonFbaReportInventoryLedgerSummary $ledgerSummary, int $quantity, string $notes, ?Carbon $dateOverride = null): InventoryAdjustment
    {
        $adjustmentDate = $dateOverride ?? $ledgerSummary->event_datetime;

        $inventoryAdjustment = InventoryAdjustment::create([
            'adjustment_date' => $adjustmentDate,
            'product_id' => $ledgerSummary->amazonFnskuProduct->product_id,
            'warehouse_id' => $ledgerSummary->integrationInstance->warehouse->id,
            'quantity' => $quantity,
            'notes' => $notes,
        ]);

        $inventoryManager = InventoryManager::with(
            $inventoryAdjustment->warehouse_id,
            $inventoryAdjustment->product
        );
        if ($inventoryAdjustment->quantity > 0) {
            $inventoryManager->addToStock(abs($inventoryAdjustment->quantity), $inventoryAdjustment, unitCost: $inventoryAdjustment->product->unit_cost);
        } else {
            $inventoryManager->takeFromStock(abs($inventoryAdjustment->quantity), $inventoryAdjustment);
        }

        return $inventoryAdjustment;
    }
}