<?php

namespace Modules\Amazon\Actions\LedgerActions\SkuModels;

use App\Exceptions\InsufficientStockException;
use Modules\Amazon\Abstractions\AmazonLedgerHandlerInterface;
use Modules\Amazon\Actions\LedgerActions\AmazonCreateInventoryAdjustmentFromLedger;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Entities\AmazonReport;
use Throwable;

class AmazonProcessInventoryAdjustment implements AmazonLedgerHandlerInterface
{
    /**
     * @throws Throwable
     * @throws InsufficientStockException
     */
    public function handle(AmazonFbaReportInventoryLedger $ledger): void
    {
        $reason = getRecordFromArray(AmazonReport::$adjustmentReasons, 'Code', $ledger->reason);
        $notes = $reason['Code'].' ('.$reason['Type'].') '.$reason['Reason'].'. '.$reason['Definition'];
        app(AmazonCreateInventoryAdjustmentFromLedger::class)->handle($ledger, $notes);
    }
}