<?php

namespace Modules\Amazon\Actions\LedgerActions;

use Closure;
use Exception;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;

class AmazonCheckIfLedgerIsReconciled
{
    /**
     * @throws Exception
     */
    public function handle(AmazonFbaReportInventoryLedger $ledger, Closure $next)
    {
        if ($ledger->reconciled_at) {
            throw new Exception('Ledger already reconciled. Ledger ID: '.$ledger->id);
        }

        return $next($ledger);
    }
}