<?php

namespace Modules\Amazon\Actions;

use App\DTO\WarehouseDto;
use App\Exceptions\DropshipWithOpenOrdersException;
use App\Models\Warehouse;
use App\Repositories\WarehouseRepository;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

class InitializeFbaWarehouse
{
    protected AmazonIntegrationInstance $amazonIntegrationInstance;

    private WarehouseRepository $warehouseRepository;

    public function __construct(AmazonIntegrationInstance $amazonIntegrationInstance, private readonly bool $initialize = true)
    {
        $this->amazonIntegrationInstance = $amazonIntegrationInstance;
        $this->warehouseRepository = app(WarehouseRepository::class);
    }

    /**
     * @throws DropshipWithOpenOrdersException
     */
    public function handle(): Warehouse|bool
    {
        customlog('amazon', 'Initializing FBA warehouse');
        if ($this->initialize) {
            if ($warehouse = $this->amazonIntegrationInstance->warehouse) {
                $warehouse->unarchived();

                return true;
            } else {
                $dto = WarehouseDto::from([
                    'name' => "FBA ({$this->amazonIntegrationInstance->name})",
                    'type' => Warehouse::TYPE_AMAZON_FBA,
                    'integration_instance_id' => $this->amazonIntegrationInstance->id,
                ]);
                return $this->warehouseRepository->createWarehouse($dto->toArray());
            }
        } else {
            $this->amazonIntegrationInstance->warehouse->archive();

            return true;
        }
    }
}
