<?php

namespace Modules\Amazon\Actions;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelManager;
use Exception;
use Modules\Amazon\Entities\AmazonFeedRequest;
use Modules\Amazon\Repositories\AmazonFeedRepository;
use Modules\Amazon\Services\AmazonClient;

class CreateAmazonFeedSubmission extends AbstractSalesChannelManager
{
    protected AmazonFeedRepository $amazonFeedRepository;

    /**
     * @throws Exception
     */
    public function __construct(protected AmazonFeedRequest $amazonFeedRequest)
    {
        parent::__construct($amazonFeedRequest->integrationInstance, new AmazonClient($amazonFeedRequest->integrationInstance));
        $this->amazonFeedRepository = app(AmazonFeedRepository::class);
    }

    /*public function handle() : AmazonFeedSubmission
    {
        // TODO: Implement
        #$feed =

        // After feed is created we delete the request record
        $this->amazonFeedRequest->delete();

        #return $feed;
    }*/
}
